*Title: Incoming Mail Setup
*Slug: incoming-mail-setup

================================================================

Email communication is an integral part of activeCollab. Your **activeCollab can check any number of POP3 or IMAP mailboxes**. You may choose to import the email messages and have sorted into the correct part of the system. This feature enables you to collaborate with your clients by using activeCollab only, to provide customer support, manage your sales, track bugs, have feature requests submitted, share files, etc.

<{note title="Incoming Mail Dependency"}>There are a few conditions that must be met in your activeCollab for Incoming Mail to work properly:

1. <{code}>IMAP<{/code}> extension needs to be installed in your PHP Setup. If you plan to connect to POP3 and IMAP servers via SSL, make sure that you have an IMAP extension compiled with SSL support.
2. If you are checking mailboxes over a secure connection, PHP needs to be compiled with SSL support.
3. Since the mailboxes need to be checked frequently, you should to configure activeCollab's <{page name="scheduled-tasks-setup"}>Scheduled Tasks<{/page}>.
4. We highly recommend you to create a **new mailbox that will be used for activeCollab only**. Please note that all emails from the mailbox are deleted after activeCollab makes the import, it is best to use a separate mailbox for this purpose, instead of your business or private email.<{/note}>

<{sub}>Setting up a New Mailbox<{/sub}>

To set up a new activeCollab mailbox, open <{option}>Administration > Email<{/option}>, click the <{option}>Manage Mailboxes<{/option}> tab and the <{option}>New Mailbox<{/option}>. Configure the mailbox that you wish to use. You may contact your hosting provider for the required setup information.

<{image name="mailing_setup.png"}>

As you can see, the required fields for the <{option}>New Mailbox<{/option}> are:

- <{option}>Account Name<{/option}> and <{option}>Email Address<{/option}> - this email address will regularly be checked for new messages that will be imported into activeCollab.

- <{option}>Server Type<{/option}> - requires information such as server type and address, port (that must be opened on your server), username and password, security type used by the email account, and mailbox name; everything needs to be entered carefully to match the information from your hosting provider.

Before adding the mailbox, please check if activeCollab can connect to it. Click <{option}>Test Connection<{/option}> button and system will do let you know whether the mailbox has been set up correctly.

You can create any number of mailboxes this way.

<{sub}>Sorting Incoming Messages<{/sub}>

After creating a mailbox, you can **determine a set of rules that activeCollab will apply when receiving an email message from that mailbox**. By doing so, you can teach activeCollab to sort and manage incoming emails. 

For example, some of emails can be imported as a new assigned task in a project, others can start a discussion, or create a new file inside your activeCollab. Still others can be moved directly to trash.

There are two ways to handle Incoming emails:

- **By Using Mail To Project**

Enable Mail to Project by opening <{option}>Administration > Project Settings<{/option}> and selecting  <{option}>Enable Mail To Project<{/option}>. Now all the projects in your activeCollab have a specific email address which can be found in the project Overview.

To create a new task, discussion or file inside that project, all you need to do is send an email with a corresponding subject to that address. For instance, to create a task, copy the desired project email address into the email "To" field, enter "Task: Task name" in the subject field and the task description into the message body, then send the email message.

- **By Using Incoming Mail Filters**

Incoming Mail filters help you to create new objects inside your activeCollab by defining sets of rules based on different filter parameters. 

Open <{option}>Administration > Email<{/option}>, click the <{option}>Manage Filters<{/option}> tab and the <{option}>New Filter<{/option}> button. You can create as many different filters as you wish. Simply set the <{term}>Actions<{/term}> that you wish activeCollab to perform on a specific email message. For example, a filter can be configured to create a New Task in a selected project and be assigned to a specific user, with the Category, Label and priority already determined.

<{note title="Managing Incoming Mail Filters"}>When using multiple incoming mail filters, make sure to sort them by importance by dragging and dropping them into place. **activeCollab checks the filters one by one, in the order that they are sorted**. If the email matches the first filter, the message is imported according to the rules defined in that filter. If not, activeCollab continues searching for a matching filter. 

Use the <{option}>Magnifying glass<{/option}> icon in the filter tool bar to see the filter details . To edit the filter, click the <{option}>Pencil<{/option}> icon and make the changes you wish. A the filter can be deleted at any time by clicking the <{option}>X<{/option}> icon.<{/note}>